#ifndef PC_COMMANDS_H
#define PC_COMMANDS_H

#include "main.h"
#include "uart.h"

#define PREV_INPUTS_SIZE (4)

extern uint8_t prevInputs[PREV_INPUTS_SIZE];
extern bool manualMode;

// command format:
// 0x00 <command> <data> <data>

// 0x00: start byte
// <command>: command byte
// <data>: data byte
// <data>: data byte

#define PC_COMM_SET_SERVO_0 (0x01)
#define PC_COMM_SET_SERVO_1 (0x02)
#define PC_COMM_SET_LED_0 (0x03)
#define PC_COMM_SET_LED_1 (0x04)
#define PC_COMM_SET_LED_2 (0x05)
#define PC_COMM_SET_LED_3 (0x06)
#define PC_COMM_GET_IR_0 (0x07)
#define PC_COMM_GET_IR_1 (0x08)
#define PC_COMM_GET_BOARD_WEIGHT (0x09)
#define PC_COMM_GET_BOARD_VOLTAGE (0x0A)
#define PC_COMM_MANUAL_MODE (0x0B)

void processInput(uint8_t input);

#endif
