#ifndef RINGBUF_H
#define RINGBUF_H

#include <stdbool.h>
#include "main.h"

#define RINGBUFFER_SIZE (64)

typedef struct ringbuffer_t
{
    char buffer[RINGBUFFER_SIZE];
    uint16_t startIndex;
    uint16_t nextEmptyIndex;
} ringbuffer_t;

int getNumFull(ringbuffer_t *ringbuffer);
int getNumEmpty(ringbuffer_t *ringbuffer);
bool bufCanWrite(ringbuffer_t *ringbuffer);
bool bufCanRead(ringbuffer_t *ringbuffer);

bool writeRingbufferChar(ringbuffer_t *ringbuffer, char value, bool critical);
bool writeRingbufferLine(ringbuffer_t *ringbuffer, char *data, bool critical);
bool writeRingbufferLen(ringbuffer_t *ringbuffer, char *data, int length, bool critical);

int readRingbufferChar(ringbuffer_t *ringbuffer, char *dst, bool critical);
int readRingbufferLine(ringbuffer_t *ringbuffer, char *dst, bool critical);
int readRingbufferLen(ringbuffer_t *ringbuffer, char *dst, int length, bool critical);

#endif