#ifndef SPI_H
#define SPI_H

#include "main.h"
#include <stdbool.h>

typedef struct spi_data_t
{
    uint16_t leds[4];       // 4 * 16 LEDs (one per side)
    int16_t servos[2];      // two servo settings
    uint16_t ir_receive[2]; // 2 IR receiver values
} spi_data_t;


// states always before the named thing
typedef enum spi_state_t
{
    SPI_STATE_LEDIR_INIT = 0,

    SPI_STATE_LEDIR_WAIT1,
    SPI_STATE_LEDIR_WAIT2,
    SPI_STATE_LEDIR_WAIT3,
    SPI_STATE_LEDIR_LAST,

    SPI_STATE_SERVOS_INIT,
    SPI_STATE_SERVOS_TXH1,
    SPI_STATE_SERVOS_TXL1,
    SPI_STATE_SERVOS_TXH2,
    SPI_STATE_SERVOS_TXL2,

    SPI_STATE_SERVOS_LAST,

    SPI_STATE_FIN,
} spi_state_t;

extern spi_data_t spi_data;
extern spi_state_t spiState;

void pinConfigSPI(void);
void waitForSPIready(bool waitForRead);
void writeDataToServos(void);
void syncLEDIRdata(void);

void spiStateMachine(bool reset);

#endif
