#include "main.h"
#include "adc-dma.h"

void pinConfigDMA(void)
{
    LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_DMA1);

		LL_DMA_ConfigTransfer(DMA1, LL_DMA_CHANNEL_2,
                          LL_DMA_DIRECTION_PERIPH_TO_MEMORY |
													LL_DMA_MODE_CIRCULAR |
													LL_DMA_PERIPH_NOINCREMENT |
													LL_DMA_MEMORY_INCREMENT |
													LL_DMA_PDATAALIGN_HALFWORD |
													LL_DMA_MDATAALIGN_HALFWORD |
													LL_DMA_PRIORITY_HIGH);

    LL_DMA_ConfigAddresses(DMA1, LL_DMA_CHANNEL_2,
                           LL_ADC_DMA_GetRegAddr(ADC2, LL_ADC_DMA_REG_REGULAR_DATA),
                           (uint32_t)&boardData,
                           LL_DMA_DIRECTION_PERIPH_TO_MEMORY);

    LL_DMA_SetDataLength(DMA1, LL_DMA_CHANNEL_2,
                         ADC_CONVERTED_DATA_BUFFER_SIZE);

    LL_DMA_EnableChannel(DMA1, LL_DMA_CHANNEL_2);
}


void pinConfigADC(void)
{
    LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOC);
    LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_ADC12);
	
		LL_ADC_SetCommonClock(__LL_ADC_COMMON_INSTANCE(ADC2), LL_ADC_CLOCK_SYNC_PCLK_DIV2);

		LL_GPIO_SetPinMode(GPIOC, LL_GPIO_PIN_2 | LL_GPIO_PIN_3 | LL_GPIO_PIN_4 | LL_GPIO_PIN_5, LL_GPIO_MODE_ANALOG);

		LL_ADC_REG_InitTypeDef ADC_REG_InitStruct;
		LL_ADC_REG_StructInit(&ADC_REG_InitStruct);

		ADC_REG_InitStruct.ContinuousMode = LL_ADC_REG_CONV_SINGLE;
		ADC_REG_InitStruct.TriggerSource = LL_ADC_REG_TRIG_EXT_TIM2_TRGO;
		ADC_REG_InitStruct.DMATransfer = LL_ADC_REG_DMA_TRANSFER_UNLIMITED;
		ADC_REG_InitStruct.Overrun = LL_ADC_REG_OVR_DATA_OVERWRITTEN;
		ADC_REG_InitStruct.SequencerLength = LL_ADC_REG_SEQ_SCAN_ENABLE_4RANKS;

		LL_ADC_REG_Init(ADC2, &ADC_REG_InitStruct);

		LL_ADC_REG_SetSequencerRanks(ADC2, LL_ADC_REG_RANK_1, LL_ADC_CHANNEL_9);
		LL_ADC_REG_SetSequencerRanks(ADC2, LL_ADC_REG_RANK_2, LL_ADC_CHANNEL_8);
		LL_ADC_REG_SetSequencerRanks(ADC2, LL_ADC_REG_RANK_3, LL_ADC_CHANNEL_11);
		LL_ADC_REG_SetSequencerRanks(ADC2, LL_ADC_REG_RANK_4, LL_ADC_CHANNEL_5);

		LL_ADC_SetChannelSamplingTime(ADC2, LL_ADC_CHANNEL_9,  LL_ADC_SAMPLINGTIME_601CYCLES_5);
		LL_ADC_SetChannelSamplingTime(ADC2, LL_ADC_CHANNEL_8,  LL_ADC_SAMPLINGTIME_601CYCLES_5);
		LL_ADC_SetChannelSamplingTime(ADC2, LL_ADC_CHANNEL_11, LL_ADC_SAMPLINGTIME_601CYCLES_5);
		LL_ADC_SetChannelSamplingTime(ADC2, LL_ADC_CHANNEL_5,  LL_ADC_SAMPLINGTIME_601CYCLES_5);
}


void activateADC(void)
{
    if (LL_ADC_IsEnabled(ADC2) == 0)
    {
        LL_ADC_Enable(ADC2);
				LL_ADC_REG_StartConversion(ADC2);
    }
}
