#include "bitops.h"

uint16_t reverseBitorder16(uint16_t value)
{
    uint16_t result = 0;
    for (int i = 0; i < 16; i++)
    {
        result = (result << 1) | (value & 1);
        value >>= 1;
    }
    return result;
}

uint8_t reverseBitorder8(uint8_t value)
{
    uint8_t result = 0;
    for (int i = 0; i < 8; i++)
    {
        result = (result << 1) | (value & 1);
        value >>= 1;
    }
    return result;
}

uint16_t interleaveBits(uint8_t a, uint8_t b)
{
    uint16_t result = 0;
    for (int i = 0; i < 8; i++)
    {
        int ith_bit_a = (a >> (7 - i)) & 1;
        int ith_bit_b = (b >> (7 - i)) & 1;
        result |= ith_bit_a << (15 - 2 * i);
        result |= ith_bit_b << (15 - 2 * i - 1);
    }
    return result;
}

int16_t get1index(uint16_t val) 
{
		for (int i = 0; i < 16; i++) 
		{
				if (val >> i & 1) return i;
		}
		return -1;
}
