#include "main.h"
#include "board.h"
#include "adc-dma.h"

float boardWeight;

boardData_t boardDataInit;
boardData_t boardData;



uint16_t avg(uint16_t *data)
{
    uint16_t sum = 0;
    for (int i = 0; i < INIT_AVG_NUM; i++)
    {
        sum += data[i];
    }
    return sum / INIT_AVG_NUM;
}

void initialReadBoard(void)
{
    uint16_t dms1[INIT_AVG_NUM];
    uint16_t dms2[INIT_AVG_NUM];
    uint16_t dms3[INIT_AVG_NUM];
    uint16_t dms4[INIT_AVG_NUM];

    for (int i = 0; i < INIT_AVG_NUM; i++)
    {
				LL_DMA_ClearFlag_TC2(DMA1); // clear the transfer complete flag

				while (!LL_DMA_IsActiveFlag_TC2(DMA1))
				{ // wait for the conversion and DMA to finishto safely have a correct value
				};

        dms1[i] = boardData.DMS1;
        dms2[i] = boardData.DMS2;
        dms3[i] = boardData.DMS3;
        dms4[i] = boardData.DMS4;
    }

    boardDataInit.DMS1 = avg(dms1);
    boardDataInit.DMS2 = avg(dms2);
    boardDataInit.DMS3 = avg(dms3);
    boardDataInit.DMS4 = avg(dms4);

    boardWeight = 0.0;
}

void convertBoardWeight(void)
{
    float voltageDMS1 = __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS1 - boardDataInit.DMS1), ADC_RES);
    float voltageDMS2 = __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS2 - boardDataInit.DMS2), ADC_RES);
    float voltageDMS3 = __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS3 - boardDataInit.DMS3), ADC_RES);
    float voltageDMS4 = __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS4 - boardDataInit.DMS4), ADC_RES);

    boardWeight = ((voltageDMS1 + voltageDMS2 + voltageDMS3 + voltageDMS4) / DMS_mV_PER_KG);
}
