#include "mapping.h"
#include "uart.h"
#include "bitops.h"
#include "spi.h"

float absFloat(float val) { return val < 0 ? -val : val; }

/*
    Board layout (from top)
  ██████████████████████████████
  ██ DMS2 ██████████████ DMS1 ██
  ██████████████████████████████
  ██████████████████████████████
^ ██████████████████████████████
| ██ DMS4 ██████████████ DMS3 ██
x ██████████████████████████████
  y -->
*/

void mapADCtoServo(void)
{
    if (boardWeight < BOARD_WEIGHT_CUTOFF)
    {
        // if the board weight is below the cutoff, dont change the servo values
        // with this, the servo values can be set by UART commands
        return;
    }

		
		// unit: mV
    float voltageDMS1 = __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS1 - boardDataInit.DMS1), ADC_RES);
    float voltageDMS2 = __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS2 - boardDataInit.DMS2), ADC_RES);
    float voltageDMS3 = __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS3 - boardDataInit.DMS3), ADC_RES);
    float voltageDMS4 = __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS4 - boardDataInit.DMS4), ADC_RES);

		// unit: kg
		float weightDMS1 = voltageDMS1 / DMS_mV_PER_KG;
		float weightDMS2 = voltageDMS2 / DMS_mV_PER_KG;
		float weightDMS3 = voltageDMS3 / DMS_mV_PER_KG;
		float weightDMS4 = voltageDMS4 / DMS_mV_PER_KG;
		
		// unit: kg
		float weightXleft = weightDMS2 + weightDMS4;
		float weightXright = weightDMS1 + weightDMS3;
		float weightYback = weightDMS4 + weightDMS3;
		float weightYfront = weightDMS2 + weightDMS1;

		float scalingXforBallMiddle = get1index(spi_data.leds[0]) == -1 ? 1 : (absFloat((get1index(spi_data.leds[0]) - 7.5) / 7.5) + 0.7);
		float scalingYforBallMiddle = get1index(spi_data.leds[1]) == -1 ? 1 : (absFloat((get1index(spi_data.leds[1]) - 7.5) / 7.5) + 0.7);

		// unit: value between -200 and 200
		spi_data.servos[0] = (int16_t)(((weightXright - weightXleft) / (float)boardWeight) * 200) * MAPPING_SCALING_FACTOR * scalingXforBallMiddle;
    spi_data.servos[1] = (int16_t)(((weightYfront - weightYback) / (float)boardWeight) * 200) * MAPPING_SCALING_FACTOR * scalingYforBallMiddle;
		//spi_data.servos[0] = 0; // 200 = kippt nach rechts, -200 = kippt nach links
		//spi_data.servos[1] = -200; // 200 = kippt nach oben / front, -200 kippt nach unten / back
		
		/*
    // calculate the heigth difference left and right, then divide by the board width. Average front and back
    double gradientX = (((voltageDMS1 - voltageDMS2) / BOARD_WIDTH) + ((voltageDMS3 - voltageDMS4) / BOARD_WIDTH)) / 2;

    // calculate the heigth difference front and back, then divide by the board length. Average left and right
    double gradientY = (((voltageDMS1 - voltageDMS3) / BOARD_LENGTH) + ((voltageDMS2 - voltageDMS4) / BOARD_LENGTH)) / 2;

    // TODO: set the correct servo channels for the directions
    // Scale the numbers to the range of -200 to +200
    spi_data.servos[0] = (int16_t)((gradientX / (double)MAX_VALUE_DMS_OFFSET_FROM_CENTER) * 200);
    spi_data.servos[1] = (int16_t)((gradientY / (double)MAX_VALUE_DMS_OFFSET_FROM_CENTER) * 200);
		*/

    if ((spi_data.servos[0]) > 200)
    {
        //writeUartLen("Value for servo 0 too big!\n", 27);
        spi_data.servos[0] = 200;
    }
    if ((spi_data.servos[0]) < -200)
    {
        //writeUartLen("Value for servo 0 too small!\n", 29);
        spi_data.servos[0] = -200;
    }
    if ((spi_data.servos[1]) > 200)
    {
        //writeUartLen("Value for servo 1 too big!\n", 27);
        spi_data.servos[1] = 200;
    }
    if ((spi_data.servos[1]) < -200)
    {
        //writeUartLen("Value for servo 1 too small!\n", 29);
        spi_data.servos[0] = -200;
    }
}

uint16_t checkLimit(const uint16_t val) {
		// this is a error check function, it should never happen. 
		// it could happen on startup and crash the board, thats why its in use
		uint16_t count = 0;
		uint16_t n = val;
    while (n) {
        count += n & 1;
        n >>= 1;
    }
		return count > 3 ? 0 : val;
}

void mapIRtoLED(void)
{
    spi_data.leds[0] = checkLimit(reverseBitorder16(spi_data.ir_receive[0]));
    spi_data.leds[1] = checkLimit(reverseBitorder16(spi_data.ir_receive[1]));

    // the leds are symmetrical but in the other order
    spi_data.leds[2] = checkLimit(spi_data.ir_receive[0]);
    spi_data.leds[3] = checkLimit(spi_data.ir_receive[1]);
}
