#include "main.h"
#include <string.h>
#include <stdio.h>
#include "pc_commands.h"
#include "uart.h"
#include "spi.h"
#include "board.h"

uint8_t prevInputs[PREV_INPUTS_SIZE];
bool manualMode = false;

void pushInput(uint8_t input)
{
    for (uint8_t i = PREV_INPUTS_SIZE - 1; i > 0; --i)
    {
        prevInputs[i] = prevInputs[i - 1];
    }

    prevInputs[0] = input;
}

void processInput(uint8_t input)
{
		__disable_irq();
    pushInput(input);
	
    char numBuf[30];
    memset(&numBuf, 0, 30);

    if (prevInputs[PREV_INPUTS_SIZE - 1] == 0x00) // check start byte
    {
        uint8_t inputParam = prevInputs[PREV_INPUTS_SIZE - 3];
				uint8_t inputParam2 = prevInputs[PREV_INPUTS_SIZE - 4];
				
        switch (prevInputs[PREV_INPUTS_SIZE - 2])
        {

        case PC_COMM_SET_SERVO_0:
            spi_data.servos[0] = inputParam2;
						spi_data.servos[0] |= inputParam << 8;
            break;

        case PC_COMM_SET_SERVO_1:
            spi_data.servos[1] = inputParam2;
						spi_data.servos[1] |= inputParam << 8;
            break;

        case PC_COMM_SET_LED_0:
            spi_data.leds[0] = inputParam2;
						spi_data.leds[0] |= inputParam << 8;
            break;

        case PC_COMM_SET_LED_1:
            spi_data.leds[1] = inputParam2;
						spi_data.leds[1] |= inputParam << 8;
            break;

        case PC_COMM_SET_LED_2:
            spi_data.leds[2] = inputParam2;
						spi_data.leds[2] |= inputParam << 8;
            break;

        case PC_COMM_SET_LED_3:
            spi_data.leds[3] = inputParam2;
						spi_data.leds[3] |= inputParam << 8;
            break;

        case PC_COMM_GET_IR_0:
            writeUartLine("IR 0: ");
            // the string does not have to be \0 terminated,
            // since this buffer is memset to 0 and cannot be overrun by a
            // 16 bit number in hex (4 digits + 2 for 0x -> 6 characters)
            sprintf(numBuf, "0x%x", spi_data.ir_receive[0]);
            writeUartLine(numBuf);
            writeUart('\n');
            break;

        case PC_COMM_GET_IR_1:
            writeUartLine("IR 1: ");
            // the string does not have to be \0 terminated,
            // since this buffer is memset to 0 and cannot be overrun by a
            // 16 bit number in hex (4 digits + 2 for 0x -> 6 characters)
            sprintf(numBuf, "0x%x", spi_data.ir_receive[1]);
            writeUartLine(numBuf);
            writeUart('\n');
            break;

        case PC_COMM_GET_BOARD_WEIGHT:
            writeUartLine("Board weight [kg]:\n");
            // the string does not have to be \0 terminated, since this buffer
            // is memset to 0 and cannot be overrun by a realistic float number
            // representing the weight on the board
            sprintf(numBuf, "%.2f", boardWeight);
            writeUartLine(numBuf);
            writeUart('\n');
						break;
				
        case PC_COMM_GET_BOARD_VOLTAGE:
            writeUartLine("Board voltage [mV]:\n");
            // the string does not have to be \0 terminated, since this buffer
            // is memset to 0 and cannot be overrun by a realistic float number
            // representing the weight on the board
						sprintf(numBuf, "1: %.2f\n", __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS1 - boardDataInit.DMS1), ADC_RES));
            writeUartLine(numBuf);
						sprintf(numBuf, "2: %.2f\n", __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS2 - boardDataInit.DMS2), ADC_RES));
            writeUartLine(numBuf);
						sprintf(numBuf, "3: %.2f\n", __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS3 - boardDataInit.DMS3), ADC_RES));
            writeUartLine(numBuf);
						sprintf(numBuf, "4: %.2f\n", __LL_ADC_CALC_DATA_TO_VOLTAGE(ADC_VREF, (float)(boardData.DMS4 - boardDataInit.DMS4), ADC_RES));
            writeUartLine(numBuf);
						break;

        case PC_COMM_MANUAL_MODE:
            // toggle manual mode
            manualMode = inputParam;
            break;

        default:
						__enable_irq();
            return; // Nothing to do
        }
        writeUartLine("READY\n");
    }
		__enable_irq();
}
