#include "timer.h"
#include "nvic.h"
#include "spi.h"
#include "mapping.h"
#include "pc_commands.h"
#include "uart.h"

void pinConfigTimer(void)
{
    /**
     * Timer is only used to start the SPI state machine
     * -> is triggered regularly
     * -> exact frequency not important (but something reasonable)
     */

    LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_TIM2);

    LL_TIM_InitTypeDef TIM_Init_Struct;
    LL_TIM_StructInit(&TIM_Init_Struct);
	
		TIM_Init_Struct.CounterMode = LL_TIM_COUNTERMODE_UP;
    TIM_Init_Struct.Prescaler = 63999;

    // TODO: Timer frequency config!
    TIM_Init_Struct.Autoreload = 9; // Multipliziert Takt mit Wert+1 -> Timer Frequenz 100Hz

    LL_TIM_Init(TIM2, &TIM_Init_Struct);

    uint32_t encoded_priority = NVIC_EncodePriority(NVIC_PRIORITY_GROUP, 1, 0);
    NVIC_SetPriority(TIM2_IRQn, encoded_priority);
    NVIC_EnableIRQ(TIM2_IRQn);
		
		LL_TIM_SetTriggerOutput(TIM2, LL_TIM_TRGO_UPDATE); // enable trigger for the ADC conversion
}

void startTimer(void)
{
    LL_TIM_EnableCounter(TIM2);   // start counting
    LL_TIM_EnableIT_UPDATE(TIM2); // enable interrupt
}

void TIM2_IRQHandler(void)
{
    // just reset the flag, this interrupt is just to restart the core
    LL_TIM_ClearFlag_UPDATE(TIM2);
	
		convertBoardWeight(); // convert the adc voltage to mass

		if (!manualMode) // manual mode -> not updating the data mappings
		{
				mapADCtoServo(); // Map the ADC data to the servo
		}

		LL_GPIO_TogglePin(GPIOA, LL_GPIO_PIN_5); // Heartbeat

		flushUart(); // Start flushing the uart buffer from this cycle (if there is anything to write)

    spiStateMachine(true); // start (and reset) the state machine
}
